#!/usr/bin/perl
use strict;

my $i=0;
my $max= $ARGV[2];
my $filename = $ARGV[1];

open FILE_LIST, "<$ARGV[0]" or die "can't open $ARGV[0]\n";

my @attr = ();

#parse /tmp/routertemp into array
while(my $fileBuf = <FILE_LIST>){
	chomp($fileBuf);
	my %map;

	$fileBuf =~ s/forward_port_proto=6/forward_port_proto=tcp/g;
	$fileBuf =~ s/forward_port_proto=17/forward_port_proto=udp/g;
	%map = split(/[&=]/, $fileBuf);
	push @attr, \%map;
}
close FILE_LIST;

open RULE_FILE, ">$filename";
my %fields = (
	forward_port_desc => '',
	forward_port_from_end => '',
	forward_port_from_start => '',
	forward_port_proto => 'tcp',
	forward_port_to_end => '',
	forward_port_to_ip => '',
	forward_port_to_start => '',
	protocol => '6',
	wan_ip => '*',
);
my $rule_count = scalar @attr;
for ($rule_count .. $max-1) {
	push @attr, \%fields;
}

sub printfunc {
	my ($f) = @_;

	for my $i (0 .. $max-1) {
		if (!exists $attr[$i]{"$f"}) {
			last;
		} else {
			print RULE_FILE "$f$i=".$attr[$i]{"$f"}."&";
		}
	}
}

my $src_ip1;
my $src_ip2;
my $src_ip3;
my $src_ip4;
($src_ip1, $src_ip2, $src_ip3, $src_ip4)=split(/\./, $attr[0]{forward_port_to_ip});

print RULE_FILE "arc_action=Apply%20Changes&b_port0=&b_port1=&clear_entry_list=all&e_port0=&e_port1=&enable=0&";
printfunc("enable");
print RULE_FILE "forward_port=20&";
printfunc("forward_port_desc");
printfunc("forward_port_enable");
printfunc("forward_port_from_end");
printfunc("forward_port_from_start");
printfunc("forward_port_proto");
printfunc("forward_port_to_end");
printfunc("forward_port_to_ip");
printfunc("forward_port_to_start");
print RULE_FILE "index=0&interface_num=7&interface_num=7&ip0=&ip_count0=&ip_range_count=&lan_b_port0=&lan_b_port1=&lan_e_port0=&lan_e_port1=&lan_ip=0&lan_ip_prefix=$src_ip1.$src_ip2.$src_ip3&lan_port_range_count=&lan_protocol0=&lan_protocol1=&location_page=nat_v.stm&location_page=nat_v.stm&op_mode=apply&port_range_count=&protocol=0&";
printfunc("protocol");
print RULE_FILE "reload=0&reload=0&restart_page=&restart_page=&restart_time=0&restart_time=0&service_name=&virtual_server_list=Active%20Worlds&";
printfunc("wan_ip");

print "$filename";
